//==============================================================================
// Project:		Wealth Transfers and their Economic Effects
// File name:	Australian Residents
// Objective: 	Create two subsets of the HILDA dataset. One that excludes those
//				with children living overseas and the other that excludes those
//				with parents or siblings living overseas. This feeds into the
//				inflow and outflow of bequests comparison.
//
// Created: 	11/05/2021
// Modified: 	15/11/2021
//==============================================================================

**************************
*** Importing the Data ***
**************************

clear

cd "XXXX"	// Set the content directory here.

use HILDA_restricted_combined_rescaled	// Importing the unconfidentialised data that includes the new weights.

// Generating a variable that indicates whether a respondent has any children living overseas.
gen child_overseas = 0
replace child_overseas = 1 if (ncdst1 == 8 | ncdst2 == 8 | ncdst3 == 8 | ncdst4 == 8 | ncdst5 == 8 | ncdst6 == 8 | ncdst7 == 8 | ncdst8 == 8 | ncdst9 == 8 | ncdst10 == 8 | ncdst11 == 8 | ncdst12 == 8 | ncdst13 == 8 | ncdst14 == 8 )

// Generating a variable that indicates whether a respondent has any parents living overseas. This question is only asked in certain waves and has to be calculated with a number of steps.
gen parent_overseas08 = 0
replace parent_overseas08 = 1 if (psbkm == 9 | psfkm == 9 | psmkm == 9) & wave == 8

gen parent_overseas12 = 0
replace parent_overseas12 = 1 if (psbkm == 9 | psfkm == 9 | psmkm == 9) & wave == 12

gen parent_overseas15 = 0
replace parent_overseas15 = 1 if (psbkm == 9 | psfkm == 9 | psmkm == 9) & wave == 15

gen parent_overseas19 = 0
replace parent_overseas19 = 1 if (psbkm == 9 | psfkm == 9 | psmkm == 9) & wave == 19

by xwaveid, sort: egen overseas_parent08 = sum(parent_overseas08)
by xwaveid, sort: egen overseas_parent12 = sum(parent_overseas12)
by xwaveid, sort: egen overseas_parent15 = sum(parent_overseas15)
by xwaveid, sort: egen overseas_parent19 = sum(parent_overseas19)

gen parent_overseas = 0
replace parent_overseas = overseas_parent08 if wave <= 9	// The observation from wave 8 is used for waves 1-9.
replace parent_overseas = overseas_parent12 if wave >= 10 & wave <= 13	// The observation from wave 12 is used for waves 10-13.
replace parent_overseas = overseas_parent15 if wave >= 14 & wave <= 16	// The observation from wave 15 is used for waves 14-16.
replace parent_overseas = overseas_parent19 if wave >= 17	// The observation from wave 19 is used for waves 17-19.

// Generating a variable that indicates wheter a respondent has any siblings living overseas. This question is also only asked in certain waves and has to be calculated with a number of steps.
gen sibling_overseas08 = 0
replace sibling_overseas08 = 1 if (bskm1 == 8 | bskm2 == 8 | bskm3 == 8 | bskm4 == 8 | bskm5 == 8 | bskm6 == 8 | bskm7 == 8 | bskm8 == 8 | bskm9 == 8 | bskm10 == 8 | bskm11 == 8 | bskm12 == 8 | bskm13 == 8 | bskm14 == 8 | bskm15 == 8 | bskm16 == 8 | bskm17 == 8 | bskm18 == 8 | bskm19 == 8) & wave == 8

gen sibling_overseas12 = 0
replace sibling_overseas12 = 1 if (bskm1 == 8 | bskm2 == 8 | bskm3 == 8 | bskm4 == 8 | bskm5 == 8 | bskm6 == 8 | bskm7 == 8 | bskm8 == 8 | bskm9 == 8 | bskm10 == 8 | bskm11 == 8 | bskm12 == 8 | bskm13 == 8 | bskm14 == 8 | bskm15 == 8 | bskm16 == 8 | bskm17 == 8 | bskm18 == 8 | bskm19 == 8) & wave == 12

gen sibling_overseas19 = 0
replace sibling_overseas19 = 1 if (bskm1 == 8 | bskm2 == 8 | bskm3 == 8 | bskm4 == 8 | bskm5 == 8 | bskm6 == 8 | bskm7 == 8 | bskm8 == 8 | bskm9 == 8 | bskm10 == 8 | bskm11 == 8 | bskm12 == 8 | bskm13 == 8 | bskm14 == 8 | bskm15 == 8 | bskm16 == 8 | bskm17 == 8 | bskm18 == 8 | bskm19 == 8) & wave == 19

by xwaveid, sort: egen overseas_sibling08 = sum(sibling_overseas08)
by xwaveid, sort: egen overseas_sibling12 = sum(sibling_overseas12)
by xwaveid, sort: egen overseas_sibling19 = sum(sibling_overseas19)

gen sibling_overseas = 0
replace sibling_overseas = overseas_sibling08 if wave <= 9	// The observation from wave 8 is used for waves 1-9.
replace sibling_overseas = overseas_sibling12 if wave >= 10 & wave <= 15	// The observation from wave 12 is used for waves 10-15.
replace sibling_overseas = overseas_sibling19 if wave >= 16	// The observation from wave 19 is used for waves 16-19.

//	Checking the variables have been calculated sensibly.
codebook parent_overseas
codebook child_overseas
codebook sibling_overseas

save HILDA_Australian_residents, replace	// Saving the dataset.

***************************************************************
*** Creating a Dataset without Overseas Parents or Siblings ***
***************************************************************

drop if parent_overseas == 1
drop if sibling_overseas == 1

save HILDA_restricted_combined_rescaled_domestic_parents_siblings, replace	// Saving the dataset.

****************************************************
*** Creating a Dataset without Overseas Children ***
****************************************************

clear

use HILDA_Australian_residents, replace

drop if child_overseas == 1

save HILDA_restricted_combined_rescaled_domestic_children, replace	// Saving the dataset.